<?php #2016-07-11
class axs_banklink {
	public $name='banklink';
	public $error=array();
	public $service='';
	public $bank_list=array();
	static $services=array('pay'=>1011, 'pay_ok'=>1111, 'pay_fail'=>1911, ); # <Columns that exist />
	static $form=array( #<Makselahenduse protokollid>
		'ipizza'=>array( #<Ipizza>
			'fields'=>array(
				'VK_SERVICE'=>array('k'=>'service', 'len'=>4, 'req'=>1),
				'VK_VERSION'=>array('k'=>'service_version', 'len'=>3, 'req'=>1, 'val'=>'008', ),
				'VK_SND_ID'=>array('k'=>'my_id', 'len'=>15, 'req'=>1),
				'VK_STAMP'=>array('k'=>'order_nr', 'len'=>20, 'req'=>1),
				'VK_AMOUNT'=>array('k'=>'sum', 'len'=>12, 'req'=>1),
				'VK_CURR'=>array('k'=>'currency', 'len'=>3, 'req'=>1),
				'VK_ACC'=>array('k'=>'account_number', 'len'=>34, 'req'=>1),
				'VK_NAME'=>array('k'=>'account_owner', 'len'=>70, 'req'=>1),
				'VK_REF'=>array('k'=>'account_ref', 'len'=>35, 'req'=>0),
				'VK_MSG'=>array('k'=>'msg', 'len'=>95, 'req'=>1),
				'VK_RETURN'=>array('k'=>'return', 'len'=>255, 'req'=>1),
				'VK_CANCEL'=>array('k'=>'cancel', 'len'=>255, 'req'=>1),
				'VK_DATETIME'=>array('k'=>'time', 'len'=>24, 'req'=>1),
				'VK_MAC'=>array('k'=>'mac', 'len'=>700, 'req'=>1,),
				'VK_ENCODING'=>array('k'=>'charset', 'len'=>12, 'req'=>0),
				'VK_LANG'=>array('k'=>'lang', 'len'=>3, 'req'=>1),
				
				'VK_T_NO'=>array('k'=>'transaction_id', 'len'=>20, 'req'=>1),
				'VK_T_DATETIME'=>array('k'=>'', 'len'=>24, 'req'=>1),
				'VK_REC_ID'=>array('k'=>'bank', 'len'=>15, 'req'=>1),
				'VK_REC_ACC'=>array('k'=>'', 'len'=>34, 'req'=>1),
				'VK_REC_NAME'=>array('k'=>'', 'len'=>70, 'req'=>1),
				'VK_SND_ACC'=>array('k'=>'', 'len'=>34, 'req'=>1),
				'VK_SND_NAME'=>array('k'=>'', 'len'=>70, 'req'=>1),
				'VK_AUTO'=>array('k'=>'', 'len'=>1, 'req'=>0),
				),
			'order'=>array(
				#<Makseteenused>
				1011=>array(
					# Teenindaja saadab panka allkirjastatud maksekorralduse andmed, mida klient internetipangas muuta ei saa. 
					# Peale edukat makset koostatakse kaupmehele päring “1111”, ebaõnnestunud makse puhul “1911”
					'VK_SERVICE'=>true, #Teenuse number (1011)
					'VK_VERSION'=>true, #Kasutatav krüptoalgoritm (008)
					'VK_SND_ID'=>true, #Päringu koostaja ID (Kaupluse ID)
					'VK_STAMP'=>true, #Päringu ID
					'VK_AMOUNT'=>true, #Maksmisele kuuluv summa
					'VK_CURR'=>true, #Valuuta nimi: EUR
					'VK_ACC'=>true, #Saaja konto number
					'VK_NAME'=>true, #Saaja nimi
					'VK_REF'=>true, #Maksekorralduse viitenumber
					'VK_MSG'=>true, #Maksekorralduse selgitus
					'VK_RETURN'=>true, #URL, kuhu vastatakse edukal tehingu sooritamisel
					'VK_CANCEL'=>true, #URL, kuhu vastatakse ebaõnnestunud tehingu puhul
					'VK_DATETIME'=>true, #Päringu algatamise kuupäev ja kellaaeg DATETIME formaadis
					'VK_MAC'=>false, #Kontrollkood e. allkiri
					'VK_ENCODING'=>false, #Sõnumi kodeering. ISO-8859-1 või UTF-8 (vaikeväärtus) või WINDOWS-1257
					'VK_LANG'=>false, #Soovitav suhtluskeel (EST, ENG või RUS)
					),
				1111=>array(
					# Kasutatakse vastamiseks eestisisese maksekorralduse toimumisest.
					'VK_SERVICE'=>true, #Teenuse number (1111)
					'VK_VERSION'=>true, #Kasutatav krüptoalgoritm 008
					'VK_SND_ID'=>true, #Päringu koostaja ID (Panga ID)
					'VK_REC_ID'=>true, #Päringu vastuvõtja ID (Kaupluse ID)
					'VK_STAMP'=>true, #Päringu ID
					'VK_T_NO'=>true, #Maksekorralduse number
					'VK_AMOUNT'=>true, #Makstud summa
					'VK_CURR'=>true, #Valuuta nimi: EUR
					'VK_REC_ACC'=>true, #Saaja konto number
					'VK_REC_NAME'=>true, #Saaja nimi
					'VK_SND_ACC'=>true, #Maksja konto number
					'VK_SND_NAME'=>true, #Maksja nimi
					'VK_REF'=>true, #Maksekorralduse viitenumber
					'VK_MSG'=>true, #Maksekorralduse selgitus
					'VK_T_DATETIME'=>true, #Maksekorralduse kuupäev ja kellaaeg DATETIME formaadis
					'VK_MAC'=>false, #Kontrollkood e. allkiri
					'VK_ENCODING'=>false, #Sõnumi kodeering. ISO-8859-1 või UTF-8 (vaikeväärtus) või WINDOWS-1257
					'VK_LANG'=>false, #Soovitav suhtluskeel (EST, ENG või RUS)
					'VK_AUTO'=>false, #Y = panga poolt automaatselt saadetud vastus. N = vastus kliendi liikumisega kaupmehe lehele
					),
				1911=>array(
					# Kasutatakse ebaõnnestunud tehingust teatamiseks.
					'VK_SERVICE'=>true, #Teenuse number (1911)
					'VK_VERSION'=>true, #Kasutatav krüptoalgoritm (008)
					'VK_SND_ID'=>true, #Päringu koostaja ID (Panga ID)
					'VK_REC_ID'=>true, #Päringu vastuvõtja ID (Kaupluse ID)
					'VK_STAMP'=>true, #Päringu ID
					'VK_REF'=>true, #Maksekorralduse viitenumber
					'VK_MSG'=>true, #Maksekorralduse selgitus
					'VK_MAC'=>false, #Kontrollkood e. allkiri
					'VK_ENCODING'=>false, #Sõnumi kodeering. ISO-8859-1 või UTF-8 (vaikeväärtus) või WINDOWS-1257
					'VK_LANG'=>false, #Soovitav suhtluskeel (EST, ENG või RUS)
					'VK_AUTO'=>false, #Y = panga poolt automaatselt saadetud vastus. N = vastus kliendi liikumisega kaupmehe lehele
					),
				#</Makseteenused>
				), #</order>
			), #</Ipizza>
		'paypal'=>array( #<PayPal>
			'fields'=>array(
				'cmd'=>array('k'=>'cmd', 'len'=>7, 'req'=>1, 'val'=>'_xclick', ),
				'business'=>array('k'=>'my_id', 'len'=>255, 'req'=>1, ),
				'lc'=>array('k'=>'lc', 'len'=>2, 'req'=>1, 'val'=>'EE', ),
				'button_subtype'=>array('k'=>'button_subtype', 'len'=>255, 'req'=>1, 'val'=>'services', ),
				'no_note'=>array('k'=>'no_note', 'len'=>1, 'req'=>1, 'val'=>'0', ),
				'item_name'=>array('k'=>'msg', 'len'=>20, 'req'=>1, ),
				'amount'=>array('k'=>'sum', 'len'=>12, 'req'=>1, ),
				'return'=>array('k'=>'return', 'len'=>255, 'req'=>1, ),
				'ipn_notification_url'=>array('k'=>'return', 'len'=>255, 'req'=>1, ),
				'notify_url'=>array('k'=>'return', 'len'=>255, 'req'=>1, ),
				'cancel_return'=>array('k'=>'cancel', 'len'=>255, 'req'=>1, ),
				'currency_code'=>array('k'=>'currency', 'len'=>3, 'req'=>1, ),
				'bn'=>array('k'=>'bn', 'len'=>255, 'req'=>1, 'val'=>'PP-BuyNowBF:btn_buynowCC_LG.gif:NonHostedGuest', ),//PP-BuyNowBF:btn_buynow_LG.gif:NonHostedGuest
				#'name'=>array('k'=>'name', 'len'=>255, 'req'=>1, ),
				#'payer_email'=>array('k'=>'email', 'len'=>255, 'req'=>1, ),
				'item_number'=>array('k'=>'order_nr', 'len'=>20, 'req'=>1, ),
/*<input type="hidden" name="cmd" value="_s-xclick">
<input type="hidden" name="hosted_button_id" value="D9REKEUCPSNGC">
<input type="image" src="https://www.paypalobjects.com/en_US/i/btn/btn_paynow_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!">
<img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1">*/
				),
			'order'=>array(
				#<Makseteenused>
				'pay'=>array(
					# Teenindaja saadab panka allkirjastatud maksekorralduse andmed, mida klient internetipangas muuta ei saa. 
					# Peale edukat makset koostatakse kaupmehele päring “1111”, ebaõnnestunud makse puhul “1911”
					'cmd'=>true,
					'business'=>true,
					'lc'=>false,
					'button_subtype'=>true,
					'no_note'=>true,
					'item_name'=>false,
					'amount'=>true,
					'return'=>true,
					'ipn_notification_url'=>true,
					'notify_url'=>true,
					'cancel_return'=>true,
					'currency_code'=>true,
					'bn'=>true,
					#'name'=>false,
					#'payer_email'=>false,
					'item_number'=>true,
					),
				#</Makseteenused>
				), #</order>
			), #</Ipizza>
		''=>array( #<(none)>
			'fields'=>array(
				'order_nr'=>array('k'=>'order_nr', 'len'=>20, 'req'=>1, ),
				'msg'=>array('k'=>'msg', 'len'=>20, 'req'=>0, 'val'=>'', ),
				'transaction_id'=>array('k'=>'transaction_id', 'len'=>20, 'req'=>0, 'val'=>'', ),
				'sum'=>array('k'=>'sum', 'len'=>10, 'req'=>0, 'val'=>0, ),
				),
			'order'=>array(
				'pay'=>array('order_nr'=>true, 'msg'=>true, 'transaction_id'=>'', 'sum'=>0, ),
				'pay_ok'=>array('order_nr'=>true, 'msg'=>true, 'transaction_id'=>'', 'sum'=>0, ),
				),
			), #</(none)>
		); #</Makselahenduse protokollid>
	public $bank_def=array(
		'ipizza'=>array(
			'text'=>array('et'=>'Ipizza Testpank', ),
			'home'=>'http://pangalink.net',
			'banklink_address'=>'http://localhost:8080/banklink/ipizza',
			'banklink_address_test'=>'http://localhost:8080/banklink/ipizza',
			'currency'=>array('EUR', ),
			'charset'=>array('UTF-8',),
			'language'=>array('en'=>'ENG', ),
			'service'=>array('pay'=>1011, 'pay_ok'=>1111, 'pay_fail'=>1911, ),
			'service_version'=>'008',
			'protocol'=>'ipizza',
			),
		'SEB'=>array(
			'text'=>array('et'=>'SEB. Siin saate maksta U-Netis', ),
			'home'=>'http://www.seb.ee/unet',
			'banklink_address'=>'https://www.seb.ee/cgi-bin/unet3.sh/un3min.r',
			'banklink_address_test'=>'https://www.seb.ee/cgi-bin/dv.sh/ipank.r',
			'currency'=>array('EUR', ),
			'charset'=>array('UTF-8', 'ISO-8859-1', ),
			'language'=>array('et'=>'EST', 'en'=>'ENG', ),
			'service'=>array('pay'=>1011, 'pay_ok'=>1111, 'pay_fail'=>1911, ),
			'service_version'=>'008',
			'protocol'=>'ipizza',
			),
		'SWED'=>array(
			'text'=>array('et'=>'Swedbank. Siin saate maksta internetipangas', ),
			'home'=>'https://www.swedbank.ee/',
			'banklink_address'=>'https://www.swedbank.ee/banklink',
			'banklink_address_test'=>'http://localhost:8080/banklink/swedbank-common',#'https://www.hanza.net/cgi-bin/hanza/pangalink.jsp',
			'currency'=>array('EUR', ),
			'charset'=>array('UTF-8', 'ISO-8859-1', ),
			'language'=>array('et'=>'EST', 'en'=>'ENG', ),
			'service'=>array('pay'=>1011, 'pay_ok'=>1111, 'pay_fail'=>1911, ),
			'service_version'=>'008',
			'protocol'=>'ipizza',
			),
		'SAMPOPANK'=>array(
			'text'=>array('et'=>'Sampo internetipank', ),
			'home'=>'http://www.sampopank.ee/',
			'banklink_address'=>'https://www2.sampopank.ee/ibank/pizza/pizza',
			'banklink_address_test'=>'http://195.190.134.117/ibank/pizza/pizza',
			'currency'=>array('EUR', ),
			'charset'=>array('UTF-8', 'ISO-8859-1', ),
			'language'=>array('et'=>'EST', 'en'=>'ENG', ),
			'service'=>array('pay'=>1011, 'pay_ok'=>1111, 'pay_fail'=>1911, ),
			'service_version'=>'008',
			'protocol'=>'ipizza',
			),
		'NORDEA'=>array(
			'text'=>array('en'=>'Nordea, E-Payment', ),
			'home'=>'http://www.nordea.ee/',
			'banklink_address'=>'https://netbank.nordea.com/pnbepay/epayn.jsp',
			'banklink_address_test'=>'https://netbank.nordea.com/pnbepaytest/epayn.jsp',
			'currency'=>array('EUR', ),
			'charset'=>array('ISO-8859-1', ),
			'language'=>array('en'=>3, 'et'=>4, 'lv'=>6, 'lt'=>7, ),
			'service'=>array('pay'=>1011, 'pay_ok'=>1111, 'pay_fail'=>1911, ),
			'service_version'=>'008',
			'protocol'=>'ipizza',
			),
		'paypal'=>array(
			'text'=>array('et'=>'PayPal', ),
			'home'=>'https://www.paypal.com',
			'banklink_address'=>'https://www.paypal.com/cgi-bin/webscr',
			'banklink_address_test'=>'https://www.sandbox.paypal.com/cgi-bin/webscr',
			'currency'=>array('EUR', 'GBP', 'USD', ),
			'charset'=>array('UTF-8',),
			'language'=>array('en'=>'ENG', ),
			'service'=>array('pay'=>'pay', 'pay_ok'=>'pay_ok', 'pay_fail'=>'pay_fail', ),
			'protocol'=>'paypal',
			),
		'-'=>array(
			'text'=>array('et'=>'Tasumine arve alusel', ),
			'service'=>array('pay'=>'pay', 'pay_ok'=>'pay_ok', ),
			'protocol'=>'',
			),
		);
	function __construct($l='', $site_nr=1) { # class constructor
		global $axs;
		$this->site_nr=($site_nr) ? $site_nr:1;
		$this->px=$axs['cfg']['site'][$this->site_nr]['prefix'];
		$this->db=$axs['cfg']['site'][$this->site_nr]['db'];
		$tmp=(array)$axs['cfg']['site'][$this->site_nr]['langs'];
		$this->l=($l) ? $l:current($tmp);
		$this->services=self::$services;
		} #</__construct()>
	function log($function, $line, $msg) { # <Log errors />
		if (is_array($msg)) {	$msg=(count($msg)>1) ? "\n".implode("	\n", $msg):implode("	\n", $msg);	}
		return axs_log(__FILE__, $line, 'banklink', $msg=get_class($this).'::'.$function.'() line '.$line.': '.$msg);
		} # </log()>
	
	function bank_get($bank_id, $service, $key=false) { # <Get bank data />
		$this->bank=$this->bank_service=$this->bank_service_code='';
		$this->bank_data=array();
		//if (!isset($this->services[$service])) $this->error[]='Invalid service "'.$service.'" ('.__LINE__.')';
		$this->bank_data=axs_db_query("SELECT *, `id` AS `bank_id` FROM `".$this->px.$this->name."` WHERE `mode`!=0 AND (`id`='".addslashes($bank_id)."' OR `bank`='".addslashes($bank_id)."') LIMIT 1", 'row', $this->db, __FILE__, __LINE__);
		if (empty($this->bank_data)) $this->error[]='Bank not found bank="'.$bank_id.'" ('.__LINE__.')';
		else {
			$this->bank=$bank_id;
			$this->bank_data+=$this->bank_def[$this->bank_data['bank']];
			//exit(dbg($service,$this->bank_data));
			if (isset($this->bank_data['service'][$service])) {
				$this->bank_service=$service;
				$this->bank_service_code=$this->bank_data['service'][$this->bank_service];
				}
			else $this->error[]='Invalid service "'.$service.'" @ bank="'.$bank_id.'" ('.__LINE__.')';
			if (empty($this->bank_data['language'])) $this->bank_data['language']=array($this->l=>$this->l, );
			$this->bank_data['lang']=(isset($this->bank_data['language'][$this->l])) ? $this->bank_data['language'][$this->l]:current($this->bank_data['language']);
			foreach (array( # <Test mode>
				'banklink_address',/*'my_private_key','my_private_key_password','bank_certificate','my_id','account_number',
				'account_ref','account_owner',*/
				) as $v) {
				if (($this->bank_data['mode']==-1) && (isset($this->bank_data[$v.'_test']))) $this->bank_data[$v]=$this->bank_data[$v.'_test'];
				unset($this->bank_data[$v.'_test']);
				} # </Test mode>
			# <Check bank data>
			if ($this->bank_data['protocol']) foreach (array('id','bank',/*'my_private_key','bank_certificate',*/'my_id',/*'account_number','account_owner',*/) as $v) {
				if (!strlen($this->bank_data[$v])) $this->error[]='Empty field "'.$v.'" @ bank="'.$bank_id.'" ('.__LINE__.')';
				} # </Check bank data>
			}
		if (!empty($this->error)) $this->log(__FUNCTION__, __LINE__, $this->error);
		if ($key!==false) return $this->bank_data[$key];
		return $this->bank_data;
		} # </bank_get()>
	function form_html($bank_id, $service_name, $order_data) { # Create HTML form
		global $axs;
		$form=false;
		$this->bank_get($bank_id, $service_name);
		if (!empty($this->error)) return false;
		$this->http_method='post';
		# <Set up order data>
		$this->values=array_merge($this->bank_data, $order_data);
		$this->values['service']=$this->bank_service_code;
		$this->values['text']=(isset($this->values['text'][$this->l])) ? $this->values['text'][$this->l]:current($this->values['text']);
		# </Set up order data>
		# <Set fields />
		$this->fields=array();			
		foreach (self::$form[$this->bank_data['protocol']]['order'][$this->bank_service_code] as $k=>$v) {
			$v=self::$form[$this->bank_data['protocol']]['fields'][$k];
			$this->fields[$k]=(isset($v['val'])) ? $v['val']:axs_get($v['k'], $this->values);
			}
		if (is_callable(array($this, $tmp=$this->bank_data['protocol'].'_form_html'))) $this->$tmp();
		else $this->log(__FUNCTION__, __LINE__, 'Invalid method "'.$tmp.'" @ bank="'.$this->bank_id.'"');
		# <Error check>
		foreach (self::$form[$this->bank_data['protocol']]['order'][$this->bank_service_code] as $k=>$v) {
			$v=self::$form[$this->bank_data['protocol']]['fields'][$k];
			if ($v['req']) {	if (!strlen($this->fields[$k])) $this->error[]='Empty field "'.$k.'" ('.__LINE__.')';	}
			if (mb_strlen($this->fields[$k])>$v['len']) {
				$this->fields[$k]=mb_substr($this->fields[$k], 0, $v['len']);
				$this->error[]='"'.$k.'"="'.$this->fields[$k].'" > limit "'.$v['len'].'" ('.__LINE__.')';
				}
			} # </Error check>
		$js=($this->bank_data['mode']<0) ? '':'<script>'."\n".
		'window.onload=function() {'."\n".
		'	document.querySelector(\'#banklink input[type="submit"]\').style.display="none";'."\n".
		'	document.getElementById("banklink").submit();'."\n".
		'	};'."\n".
		'</script>'."\n";
		#$js='';
		$form='';
		foreach ($this->fields as $k=>$v) $form.='   <input type="hidden" name="'.$k.'" value="'.htmlspecialchars($v).'" />'."\n";
		#foreach ($this->fields as $k=>$v) $form.='   '.$k.'="'.htmlspecialchars($v).'"<br />'."\n";
		$form='<!DOCTYPE html>'."\n".
		'<html lang="en">'."\n".
		'<head>'."\n".
		'<meta charset="'.$axs['cfg']['charset'].'" />'."\n".
		'<title>'.htmlspecialchars($this->values['text']).'</title>'."\n".
		'<style type="text/css">'."\n".
		'form {'."\n".
		'	margin-top:10%;'."\n".
		'	text-align:center;'."\n".
		'	}'."\n".
		'</style>'."\n".
		$js.
		'</head>'."\n".
		'<body>'."\n".
		'<form id="banklink" method="'.$this->http_method.'" action="'.htmlspecialchars($this->bank_data['banklink_address']).'" enctype="application/x-www-form-urlencoded">'."\n".
		$form.
		'   <input name="submit_btn" value="To bank&gt;" type="submit" />'."\n".
		'</form>'."\n".
		'</body>'."\n".
		'</html>';
		if (!empty($this->error)) $this->log(__FUNCTION__, __LINE__, $this->error);
		return $form;
		} # </form_html()>
	function list_get($service='', $currency='', $bank_id=false) { # <Get list of banks (specify service or all) />
		$where='';
		if ($bank_id) $where[]="`id`='".($bank_id+0)."'";
		if ($service) foreach ((array)$service as $v) {
			if (!isset($this->services[$v])) return false;
			$where[]="FIND_IN_SET('".$v."',`services`)>0";
			}
		if ((empty($this->bank_list)) or ($this->service!=$service)) {
			$this->bank_list=array();
			$result=axs_db_query("SELECT `id`, `bank`, `mode`, `comment` FROM `".$this->px.$this->name."` WHERE ".implode(' AND ', $where)." AND `mode` ORDER BY `rank` ASC", 1, $this->db, __FILE__, __LINE__);
			foreach ($result as $cl) {
				if (!isset($this->bank_def[$cl['bank']])) {
					$this->log(__FUNCTION__, __LINE__, 'Invalid bank code "'.$cl['bank'].'"');
					continue;
					}
				$cl+=$this->bank_def[$cl['bank']];
				$cl['text']=(isset($cl['text'][$this->l])) ? $cl['text'][$this->l]:current($cl['text']);
				$cl['test_mode']=($cl['mode']==-1) ? 'test':'';
				$tmp=strtolower($cl['bank']);
				$cl['img.logo']=axs_file_choose(array(
					'axs.banklink.'.$tmp.'.'.$this->l.'.png',
					'axs.banklink.'.$tmp.'.en.png',
					'axs.banklink.'.$tmp.'.png',
					), 'http');
				$cl['img.pay']=axs_file_choose(array(
					'axs.banklink.'.$tmp.'.pay.'.$this->l.'.png',
					'axs.banklink.'.$tmp.'.pay.en.png',
					'axs.banklink.'.$tmp.'.pay.png',
					'axs.banklink.'.$tmp.'.png',
					), 'http');
				$this->bank_list[$cl['id']]=$cl;
				}
			}
		$this->service=$service;
		$return=$this->bank_list;
		if ($currency) foreach ($return as $k=>$v) if ((!empty($v['currency'])) && (!in_array($currency, $v['currency']))) unset($return[$k]);
		return $return;
		} # </list_get()>
	function reply_get($bank_id, $service_name, $transaction_data=array(), $log=true) { # <Verify bank reply />
		global $axs;
		$error=array();
		if (!$bank_id) $error[]='$bank_id not found (line:'.__LINE__.')';
		$this->reply_data=(!empty($_POST)) ? $_POST:$_GET;
		$this->reply_data['service']=$service_name;
		$this->bank_get($bank_id, $service_name);
		$this->bank_reply=array('bank'=>$this->bank_data['bank'], 'bank_id'=>$this->bank_data['id'], 'authentic'=>false, 'status'=>'tech', );
		$this->transaction_data=$transaction_data;
		if ($this->bank) {
			if (is_callable(array($this, $tmp=$this->bank_data['protocol'].'_reply_get'))) $this->$tmp();
			else $error[]='Invalid method "'.$tmp.'" @ bank="'.$this->bank.'" (line:'.__LINE__.')';
			}
		if (!empty($_GET['cancel'])) $this->bank_reply['status']='fail';
		#exit(dbg($this->bank_data, $this->bank_reply, $this->reply_data, $_POST));
		if ($this->bank_reply['status']!=='ok') $error[]='Banklink transaction failed: msg="'.$this->bank_reply['status'].'" (line:'.__LINE__.')';
		if ($log) {
			axs_db_query("INSERT INTO `".$this->px.$this->name."_log`\n".
			"	SET `time`='".time()."', `transaction_id`='".addslashes($this->bank_reply['transaction_id'])."', `bank_id`='".addslashes($this->bank_reply['bank_id'])."', `status`='".addslashes($this->bank_reply['status'])."', `data`='".addslashes(serialize($this->reply_data))."'",
			'', $this->site_nr, __FILE__, __LINE__);
			if (!$this->bank_reply['authentic']) $error[]='Banklink authentication failed: bank="'.$this->bank_data['bank'].'" msg="'.$this->bank_reply['status'].'" (line:'.__LINE__.')';
			}
		if (!empty($error)) $this->log(__FUNCTION__, __LINE__, $error);
		//axs_log(__FILE__, __LINE__, 'cart', $this->bank_reply);
		//if (!empty($this->exit)) exit();
		return $this->bank_reply;
		} # </reply_get()>
	/*function validate($data, $service_code) {
		foreach (self::$form[$data['protocol']]['order'][$service_code] as $k=>$v) {
			$v=self::$form[$data['protocol']]['fields'][$k];
			if ($v['req']) {	if (!$this->fields[$k]) $this->error[]='Empty field "'.$k.'" ('.__LINE__.')';	}
			if (mb_strlen($this->fields[$k])>$v['len']) {
				$this->fields[$k]=mb_substr($this->fields[$k], 0, $v['len']);
				$this->error[]='"'.$k.'"="'.$this->fields[$k].'" > limit "'.$v['len'].'" ('.__LINE__.')';
				}
			} # </Error check>
		}*/ #</validate()>
	
	#<Protocol-specific functions>
	#	<(none)>
	function _form_html() {
		$this->bank_data['banklink_address']=$this->values['return'];
		} # </_form_html()>
	function _reply_get() {
		# <Reply data>
		$this->reply_data['service']='pay_ok';
		foreach (self::$form['']['order'][$this->reply_data['service']] as $k=>$v) $this->bank_reply[$k]=$v;
		$this->bank_reply['order_nr']=$this->bank_reply['msg']=axs_get('order_nr', $this->reply_data);
		$this->bank_reply['authentic']=true;
		$this->bank_reply['status']='ok';
		# </Reply data>
		} # </_reply_get()>
	#	</(none)>
	
	#	<Ipizza>
	function ipizza_form_html() {
		global $axs;
		$this->fields['VK_LANG']=(isset($this->bank_data['language'][$this->values['lang']])) ? $this->bank_data['language'][$this->values['lang']]:current($this->bank_data['language']);
		if (!in_array($this->values['currency'], $this->bank_data['currency'])) $this->error[]='Invalid currency "'.$this->fields['currency'].'" ('.__LINE__.')';
		$this->fields['VK_DATETIME']=new DateTime('NOW');
		$this->fields['VK_DATETIME']=$this->fields['VK_DATETIME']->format(DateTime::ISO8601);#date('Y-m-dTH:i:sO');#date('c'); #'2013-03-13T07:21:14+0200'
		$this->fields['VK_ENCODING']=current($this->values['charset']);
		foreach ($this->values['charset'] as $v) if (strtolower($v)===strtolower($axs['cfg']['charset'])) $this->fields['VK_ENCODING']=$v;
		$this->fields['VK_MAC']='';
		$signature='';
		$this->fields['VK_MAC']=$this->ipizza_mac_string($this->fields, $this->bank_service_code);
		$key=@openssl_pkey_get_private($this->bank_data['my_private_key'], $this->bank_data['my_private_key_password']);
		if (!@openssl_sign($this->fields['VK_MAC'], $signature, $key, OPENSSL_ALGO_SHA1)) $this->error[]='Unable to generate signature ('.__LINE__.')';
		$this->fields['VK_MAC']=base64_encode($signature); # </MAC>
		} # </ipizza_form_html()>
	function ipizza_mac_string($values, $service_code) { # <Find MAC fieldname from a bank />
		$data='';
		foreach (self::$form['ipizza']['order'][$service_code] as $k=>$v) {
			if ($v) $data.=str_pad(mb_strlen($values[$k]), 3, '0', STR_PAD_LEFT).$values[$k];
			}
		return $data;
		} # </ipizza_mac_string()>
	function ipizza_reply_get() {
		if (isset(self::$form['ipizza']['order'][$this->reply_data['VK_SERVICE']])) $this->bank_service_code=$this->reply_data['VK_SERVICE'];
		else {
			$this->bank_service_code='';
			$this->log(__FUNCTION__, __LINE__, 'Invalid "VK_SERVICE"="'.$this->reply_data['VK_SERVICE'].'"');
			}
		# <Reply data>
		foreach (array('order_nr'=>'VK_STAMP', 'msg'=>'VK_MSG', 'transaction_id'=>'VK_T_NO', 'sum'=>'VK_AMOUNT', ) as $k=>$v) {
			$this->bank_reply[$k]=axs_get($v, $this->reply_data);
			}
		# </Reply data>
		# <Reply authentication>
		$key=openssl_pkey_get_public($this->bank_data['bank_certificate']);
		if (openssl_verify($this->ipizza_mac_string($this->reply_data, $this->bank_service_code), base64_decode($this->reply_data['VK_MAC']), $key)) {
			$this->bank_reply['authentic']=true;
			$this->bank_reply['status']=($this->reply_data['VK_SERVICE']==1111) ? 'ok':'fail';
			}
		# </Reply authentication>
		} # </ipizza_reply_get()>
	#	</Ipizza>
	
	#	<PayPal>
	function paypal_form_html() {
		//$this->fields['language']=$this->values['lang'];
		} # </paypal_form_html()>
	function paypal_reply_get() {
		if ((!isset($_POST['txn_id'])) && (!isset($_POST['txn_type']))) {
			$this->bank_reply['authentic']=true;
			$this->bank_reply['status']='ok';
			$this->bank_reply['sum']=0;
			return;
			}
		//$this->exit=true;
		$error=array();
		# <Reply data>
		foreach (array('order_nr'=>'item_number', 'transaction_id'=>'txn_id', 'sum'=>'mc_gross', 'currency'=>'mc_currency', 'my_id'=>'receiver_email', 'status'=>'payment_status', ) as $k=>$v) {
			$this->bank_reply[$k]=axs_get($v, $this->reply_data);
			}
		# </Reply data>
		# <Reply authentication>
		foreach (array('order_nr'=>'order_nr', 'sum'=>'sum.total', 'currency'=>'currency', ) as $k=>$v) if ($this->bank_reply[$k]!=$this->transaction_data[$v]) $error[]=$this->log(__FUNCTION__, __LINE__, 'Invalid response '.$k.'!="'.$this->transaction_data[$v].'" ("'.$this->bank_reply[$k].'")');
		foreach (array('my_id'=>'', ) as $k=>$v) if ($this->bank_reply[$k]!==$this->bank_data[$k]) $error[]=$this->log(__FUNCTION__, __LINE__, 'Invalid response '.$k.'="'.$this->bank_reply[$k].'" (!='.$this->bank_data[$k].')');
		if (!empty($error)) {	$this->bank_reply['status']='tech';	axs_log(__FILE__, __LINE__, 'paypal', $this->transaction_data);}
		#<read the post from PayPal system and add 'cmd' />
	    $req='cmd=_notify-validate';
		foreach ($_POST as $key=>$value) {
			$value=urlencode(stripslashes($value));
			$value=preg_replace('/(.*[^%^0^D])(%0A)(.*)/i','${1}%0D%0A${3}',$value);// IPN fix
			$req.='&'.$key.'='.$value;
			}
		// post back to PayPal system to validate
		$url=parse_url($this->bank_data['banklink_address']);
		$header="POST ".$url['path']." HTTP/1.1\r\n";
		$header.="Host: ".$url['host']."\r\n";
		$header.="Content-Type: application/x-www-form-urlencoded\r\n";
		$header.="Content-Length: " . strlen($req) . "\r\n";
		$header.="Connection: close\r\n\r\n";
		$fp = fsockopen($tmp='ssl://'.$url['host'], 443, $errno, $errstr, 30);
		if (!$fp) return $this->log(__FUNCTION__, __LINE__, 'HTTP request failed '.$tmp.' Error '.$errno.' '.$errstr);# HTTP ERROR
		else {
			fputs($fp, $header.$req);
			$verified=$response='';
			while (!feof($fp)) {
				$res = fgets ($fp, 1024);
				$response.=$res;
				if (strcmp(trim($res), "VERIFIED")!== false) {
					$this->bank_reply['authentic']=$verified=true;
					if (empty($error)) $this->bank_reply['status']='ok';
					}
				}
			fclose($fp);
			if (!$verified) $this->log(__FUNCTION__, __LINE__, 'Paypal response not verified'."\n".'Request:'."\n".$req."\n\n\n".'Response:'."\n".$response);
			}
		# </Reply authentication>
		} # </paypal_reply_get()>
	#	</PayPal>
	# </Protocol-specific functions>
	} # </class::axs_banklink>
/*
CREATE TABLE IF NOT EXISTS `axs_banklink` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rank` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `mode` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0=disabled, 1=normal, -1=test',
  `bank` varchar(255) NOT NULL DEFAULT '',
  `comment` varchar(255) NOT NULL DEFAULT '',
  `my_private_key` text NOT NULL,
  `my_private_key_password` varchar(255) NOT NULL DEFAULT '',
  `bank_certificate` text NOT NULL,
  `my_id` varchar(255) NOT NULL DEFAULT '',
  `account_number` varchar(255) NOT NULL DEFAULT '',
  `account_ref` varchar(255) NOT NULL DEFAULT '',
  `account_owner` varchar(255) NOT NULL DEFAULT '',
  `services` set('','pay','ident') CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'updated timestamp',
  `updated_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '=users.id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
--
-- Dumping data for table `axs_banklink`
--
INSERT INTO `axs_banklink` VALUES(9, 0, 1, '-', 'Tasumine arve alusel', '', '', '', '', '', '', '', 'pay', 0, 0);
INSERT INTO `axs_banklink` VALUES(8, 0, -1, 'ipizza', 'ipizza', '-----BEGIN RSA PRIVATE KEY-----\r\nMIIEpAIBAAKCAQEA0+TK9XxfjX7iGV30tIWnS8AQJURlhlQeV23Vo9KQk0YrpWwO\r\n2T5albfnySexo5SjAUkomZ5B55bK4Grri7HDDm4PQ+5g2KxEFSZ0D9aHfTgAJI+q\r\nOXhlZsw8fu/ocChNapqc9aHrVZv87GCskQcFiTje02M0+7xrd/N6x7ca6L7IjzST\r\ncf6v40R22lPmu0dB4Ad6N5USRmFI0ykxcInU+5UPUw4wepu2SVo2TukjmvgtOAwR\r\n48C6XzkwU0v20PeBKwqqQaZ1ivD47TylfQ5q0m5V794t/0LJ4GX0H2eEwkl6UQyr\r\nr9ZLRuQ/GJ90XUdqJZyC19x9dkuUvi331DcmWQIDAQABAoIBADbVvrBIv3GepGRs\r\nLCeLbv/rdEIwsRVSL4fwpJkApOl3/1OP40fVGxwju5gS7aWnkYeDpz4Z9nQ4UchB\r\n4zMDjbbuRIUP64AnFHdkvCRdIDMHiwHrK+IzhgpUUFOJQl3EEETGPlhSztQYyhth\r\n6Uaeyo/4Z7HMuqlq2WTxXZTRjeUtAas/CpMNEYEvgSU85py0YFxQWxJMzN7PP8Tv\r\nA0MGEoDelpitnuHZMowbww3/f2oi30saFHgX1SeyrfyfFGQZjNzZTGQsYiTN3BDI\r\n+EDBX2BJihQl9TFEvjeF0G5CFRbqFOOtyRmpfzfExOR4pHMbRMFtC+afocTIhmhU\r\nEFuuZAECgYEA7BvJaq/+tD4X/NnHN8vILcg+f+hKNxMEBofMihCGUgvN78tqGA6N\r\nvH0rsHYElRDCqtoDfRHFzVf6AWjcWgt7i4u5xAB/DKL5B1/wNbk3y5t3KWHRKPP6\r\nc/MeMA6lww09ggrAXpfcpymcM0zcP7ZwJCvnrjs1FoqymLeIQTNcdUUCgYEA5b7C\r\nQZoJF3H1YJJzYzK2L9snx417p1emN10CsEe4zTd9WZ+6cRBmixsuS0EvtI2OPgz8\r\ngyhBPyYKsJ3r+XaKrVB9rkMx8NumyIQLk1yRjFoXYT0lB5dzFzDXleAs77Mgj7wd\r\nQWOHRegW1Bv7GeiJJam9Ut2v+D4J14uPmtvNLAUCgYEAtdWQgQGZfuZzQt/VdTsT\r\np26X85nJzjBu4TikZY/kYjuFFi/qPSy4K3matAOv8708rqfIGAIf+8zNVViUmyRM\r\nuWOaZUCcl/bLIsrYDAfg2IWad9xFYOzE7ZdGoGwnbNg9jnEJRdBetr5s9XU0Cj1O\r\nkAzgGGaws/ONJ9/wp4YOpqECgYA8xrbq1c3b5uirsHJX5p1tkYM3dgUlIrm04aUJ\r\nbx/DIg/F+sw+hsEpwXoArHDrSZs8bQELzUVdaDnhuRUovCQ5bxagV+RJPEIlv1C0\r\nngNe5qJStfMqy/TFSMVvP4uDqZZOj8wJdUPeyWPonrJRi0NktD+CQWUAvaCq5Z+K\r\nruTa5QKBgQCdBcpAHVEzqp45PqwyGzBLJz3RvA93G3ivwu++OfZvu48rCRXY9K1O\r\nkBUY1y93N0pID6Cix3MN/mXI600/DcIx0Jmg44pSt7ueQfmsYewEVPdxCta4ObPb\r\nzAmV1xQciGCtwggIIn6yLU0l8S45DhCP2laSBqHxftY4cqyYZtOxeg==\r\n-----END RSA PRIVATE KEY-----', '-----BEGIN RSA PRIVATE KEY-----\r\nMIIEpAIBAAKCAQEA0+TK9XxfjX7iGV30tIWnS8AQJURlhlQeV23Vo9KQk0YrpWwO\r\n2T5albfnySexo5SjAUkomZ5B55bK4Grri7HDDm4PQ+5g2KxEFSZ0D9aHfTgAJI+q\r\nOXhlZsw8fu/ocChNapqc9aHrVZv87GCskQcFiTje02M0+7xrd/N6x7ca6L7IjzST\r\ncf6v40R22lPmu0dB4Ad6N5USRmFI0ykxcInU+5UPUw4wepu2SVo2TukjmvgtOAwR\r\n48C6XzkwU0v20PeBKwqqQaZ1ivD47TylfQ5q0m5V794t/0LJ4GX0H2eEwkl6UQyr\r\nr9ZLRuQ/GJ90XUdqJZyC19x9dkuUvi331DcmWQIDAQABAoIBADbVvrBIv3GepGRs\r\nLCeLbv/rdEIwsRVSL4fwpJkApOl3/1OP40fVGxwju5gS7aWnkYeDpz4Z9nQ4UchB\r\n4zMDjbbuRIUP64AnFHdkvCRdIDMHiwHrK+IzhgpUUFOJQl3EEETGPlhSztQYyhth\r\n6Uaeyo/4Z7HMuqlq2WTxXZTRjeUtAas/CpMNEYEvgSU85py0YFxQWxJMzN7PP8Tv\r\nA0MGEoDelpitnuHZMowbww3/f2oi30saFHgX1SeyrfyfFGQZjNzZTGQsYiTN3BDI\r\n+EDBX2BJihQl9TFEvjeF0G5CFRbqFOOtyRmpfzfExOR4pHMbRMFtC+afocTIhmhU\r\nEFuuZAECgYEA7BvJaq/+tD4X/NnHN8vILcg+f+hKNxMEBofMihCGUgvN78tqGA6N\r\nvH0rsHYElRDCqtoDfRHFzVf6AWjcWgt7i4u5xAB/DKL5B1/wNbk3y5t3KWHRKPP6\r\nc/MeMA6lww09ggrAXpfcpymcM0zcP7ZwJCvnrjs1FoqymLeIQTNcdUUCgYEA5b7C\r\nQZoJF3H1YJJzYzK2L9snx417p1emN10CsEe4zTd9WZ+6cRBmixsuS0EvtI2OPgz8\r\ngyhBPyYKsJ3r+XaKrVB9rkMx8NumyIQLk1yRjFoXYT0lB5dzFzDXleAs77Mgj7wd\r\nQWOHRegW1Bv7GeiJJam9Ut2v+D4J14uPmtvNLAUCgYEAtdWQgQGZfuZzQt/VdTsT\r\np26X85nJzjBu4TikZY/kYjuFFi/qPSy4K3matAOv8708rqfIGAIf+8zNVViUmyRM\r\nuWOaZUCcl/bLIsrYDAfg2IWad9xFYOzE7ZdGoGwnbNg9jnEJRdBetr5s9XU0Cj1O\r\nkAzgGGaws/ONJ9/wp4YOpqECgYA8xrbq1c3b5uirsHJX5p1tkYM3dgUlIrm04aUJ\r\nbx/DIg/F+sw+hsEpwXoArHDrSZs8bQELzUVdaDnhuRUovCQ5bxagV+RJPEIlv1C0\r\nngNe5qJStfMqy/TFSMVvP4uDqZZOj8wJdUPeyWPonrJRi0NktD+CQWUAvaCq5Z+K\r\nruTa5QKBgQCdBcpAHVEzqp45PqwyGzBLJz3RvA93G3ivwu++OfZvu48rCRXY9K1O\r\nkBUY1y93N0pID6Cix3MN/mXI600/DcIx0Jmg44pSt7ueQfmsYewEVPdxCta4ObPb\r\nzAmV1xQciGCtwggIIn6yLU0l8S45DhCP2laSBqHxftY4cqyYZtOxeg==\r\n-----END RSA PRIVATE KEY-----', '', '', '-----BEGIN CERTIFICATE-----\r\nMIIDljCCAn4CCQDZSMqkE3ea0zANBgkqhkiG9w0BAQUFADCBjDELMAkGA1UEBhMC\r\nRUUxETAPBgNVBAgTCEhhcmp1bWFhMRAwDgYDVQQHEwdUYWxsaW5uMQ0wCwYDVQQK\r\nEwRUZXN0MREwDwYDVQQLEwhiYW5rbGluazEXMBUGA1UEAxMObG9jYWxob3N0IDgw\r\nODAxHTAbBgkqhkiG9w0BCQEWDnRlc3RAbG9jYWxob3N0MB4XDTE1MDcwODIwMTUy\r\nM1oXDTM1MDcwMzIwMTUyM1owgYwxCzAJBgNVBAYTAkVFMREwDwYDVQQIEwhIYXJq\r\ndW1hYTEQMA4GA1UEBxMHVGFsbGlubjENMAsGA1UEChMEVGVzdDERMA8GA1UECxMI\r\nYmFua2xpbmsxFzAVBgNVBAMTDmxvY2FsaG9zdCA4MDgwMR0wGwYJKoZIhvcNAQkB\r\nFg50ZXN0QGxvY2FsaG9zdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\r\nAMQ26TAnVpa+sIIRcbKorf2S4hGwYd3HAsseV1A2elXQYrxfkiudhCiX0krTeUQ8\r\n0CrG3GNvszogkGe5Pef18HH2nKERgiqQuaNBRi8xD5ig4VtBw6/yGJ2QZMFDFbYL\r\nQ5a0Y8MR0mE2YL1E9hE+6ya6SwdxA9z6vHAUC1Oz/UIGoeWxHk//+DiHRIwVmNbV\r\nEZjrLug1oJuMh+ENGIsSREbczdWx3CQsxAVMJA4DLdDoYSm/4Z5sxFVmQ9D2mkro\r\nUNW/iV/zYyf0poPY+QQptzlVKzvQ6pZrfchS1vBJ5KCtR/M2awc4FOvGIDLPR+QZ\r\n02986dVIjBFs0x1NaksxG/0CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAtnER02Jx\r\nviCSJ4OaFTWBNunGHJYUK+cG4RMbNJaCQcHRy4K8il4QcFGX8QaeXfnyEUOB9+F8\r\niN+CDwj6tDA75TTaF6JlTnpN3AZI2MPlrT2tCwY6wHmXnsur1nADNgzORrQ5XAEZ\r\ngYxK/PKXgFRiz/MH6UHMXhyzpkyK37GU/NWtEcAzVSqq1lbXX4DjA0bMljyp4yC4\r\nTLgMALkaJg/25zJM2IOeD2TsE/b6QlXO5SCZDA7B6aVgLaIgRJxitzwWHJTr52fP\r\n+9+/KPH40EGXvfwk6Zkv9TkbSjn29K6N6N+IQmwfpdl7BK0BVSJUazkUMgIH2DbR\r\nwY9zy8r9Cu5idA==\r\n-----END CERTIFICATE-----', 'uid100010', 'EE502200001108057938', '123', 'Test Kaupmees', 'pay', 0, 0);
--
-- Table structure for table `axs_banklink_log`
--
CREATE TABLE IF NOT EXISTS `axs_banklink_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `transaction_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '=order.id',
  `bank_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '=banklink.id',
  `status` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL,
  `data` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
*/
#2008-10-20 ?>