//2022-07-29
/* UI elements: tabs
Include the scripts in the <head>: 
<script src="axs.js"></script>
<script src="axs.ui.tabs.js"></script>

HTML structure:
<div class="tabs">
	<ul class="nav"><li class="current"><a href="#tab1">lorem</a></li><li><a href="#tab2">ipsum</a></li></ul>
	<div id="tab1" class="tab current">Lorem ipsum...</div>
	<div id="tab2" class="tab">Dolor sit amet...</div>
</div>
<script>axs.ui.tabs("div.tabs");</script>*/

axs.ui.tabs={
	css:{
		'.axs.tabs.js .tab':'display:none;',
		'.axs.tabs.js .tab.current':'display:block;'
		}
	init:function(node){
		if (typeof(node)==='string') node=document.querySelector(node);
		if (!node) return axs.log('axs.ui.tabs','Node not found!');
		axs.class_add(node,'js');
		var el=node.querySelectorAll('.tab');//<Prevent window hash scroll />
		for (var i=0, len=el.length; i<len; ++i) el[i].setAttribute('id',el[i].id+'-js');
		
		var el=node.querySelectorAll('.nav>*>a');//<Set click events />
		for (var i=0, len=el.length; i<len; ++i) el[i].addEventListener('click',function(e){
			e.preventDefault();
			axs.ui.tabs.currentSet(this.getAttribute('href'));
			});
		//<Set current tab if hash present in URL />
		if ((window.location.hash)&&(node.querySelector('.nav>li a[href="'+window.location.hash+'"]'))) this.currentSet(window.location.hash);
		//<Set first tab as current if current still not set />
		if (!node.querySelector('.nav>*.current')) this.currentSet(node.querySelector('.nav>*>a').getAttribute('href'));
		},//<init()>
	currentSet:function(id){
		var p=document.querySelector(id+'-js').parentNode;
		while (!axs.class_has(p,'tabs')) p=p.parentNode;
		axs.class_rem(p.querySelectorAll('.nav>li, .tab'),'current');
		axs.class_add(p.querySelector('.nav>li a[href="'+id+'"]').parentNode,'current');
		axs.class_add(p.querySelector(id+'-js'),'current');
		}//</currentSet()>
	}//</class::axs.ui.tabs>
//2022-07-28