//2017-08-16
/*Horizontal slider function. Requires AXIS CMS JS API "axs.js" included first. 
Sample HTML: 
<section id="slider1">
	<a class="play" href="#slider1"><img src="slider.play.png" alt="play" lang="en" /></a>
	<a href="#slider1" class="scroll prev"><img src="slider.prev.png" alt="&lt;" /></a>
	<a href="#slider1" class="scroll next"><img src="slider.next.png" alt="&gt;" /></a>
	<h2>{$title}</h2>
	<div class="list clear-content">
		<article>
			<a href="#" class="scroll prev"><img src="slider.prev.png" alt="&lt;" /></a>
			<a href="#" class="scroll next"><img src="slider.next.png" alt="&gt;" /></a> 
			Lorem ipsum...
		</article>
		<article>
			<a href="#" class="scroll prev"><img src="slider.prev.png" alt="&lt;" /></a>
			<a href="#" class="scroll next"><img src="slider.next.png" alt="&gt;" /></a> 
			dolor sit amet...
		</article>
	</div>
	<span class="slider_pager"></span>
	<script>axs.slider.init("#slider1",{effect:'xfade',interval:10000,play:'auto'});</script>
</section>
Elements can be added or removed as necessary. The items container can also be <ul><li> or any other HTML combination. The pager element will be automatically converted to an <ul> tag and filled with <li> tags. 
For configuration options, look for the following code comments. 
*/
axs.slider={
	sliders:{},
	init:function(id){
		var a=axs.fn_args(arguments,{container:'',cfg:{}});
		if(!a.cfg.effect) a.cfg.effect='base';
		//if(!this[a.cfg.effect]) {}
		var container=(typeof(id)==='string') ? document.querySelector(id):id;
		if (!container) return console.log('Could nof find node for "'+id+'"');
		id=this.base.id_get(container);
		this.sliders[id]=Object.create(this[a.cfg.effect]);
		this.sliders[id].init(container,a.cfg);
		},//</init()>;
	base:{
		cfg:{
			effect:'base',//["string"]:Transition effect extension to load. 
				//Currently "xfade", "carousel", "scroll" and "marquee" are bundled by default, but other extensions can be added. 
			add_container:false,//["tagName"]:Adds a container around items
			next_lbl:'&gt;',//["HTML code"]:Scroll next button label
			prev_lbl:'&lt;',//["HTML code"]:Scroll back button label
			play_lbl:'<span lang="en">play</span>',//["HTML code"]:Play button label
			pause_lbl:'<span lang="en">pause</span>',//["HTML code"]:Play button label for pause state
			play:'auto',//[true]:Add play button if not present; ["auto"]:Start to play automatically
			playing:false,
			interval:5,//[seconds]:Play speed
			transition:1,//[seconds]:Transition speed
			group_count:0,//[number]:Group several items as one slide
			group_tag:'<div></div>',//["HTML code"]:HTML container for groups
			pager:false,//[true]:Fill pager with numbers; ["content"]:copy pages content to pager items
			adjust_height:false,//[true]:set equal height to all items
			css:{
				'.axs_slider .slider_pager .current':'{	font-weight:bold;	}\n'
				}
			},
		data:{},
		init:function(container){
			var a=axs.fn_args(arguments,{container:'',cfg:{}});
			id=this.id_get(container);
			this.data={node:container,current:1};
			for (k in this.cfg) this.data[k]=(typeof(a.cfg[k])!=='undefined')?a.cfg[k]:this.cfg[k];
			//this.data.interval*=1000;
			//<Remove whitespace>
			var tmp=this.data.node.querySelector('.list');
			for(var i=0, l=tmp.childNodes.length; l>i; i++){	if(!tmp.childNodes[i].nodeType) tmp.removeChild(tmp.childNodes[i]);	}
			//</Remove whitespace>
			var list=jQuery(container).find('.list');
			this.data.list=list;
			//this.data.width=jQuery(list).width();//jQuery(container).width();
			if(this.data.group_count) this.group(id,list,this.data.group_count,this.data.group_tag);
			this.data.items=jQuery(list).find('>*');
			if (!this.data.items.length) return;
			
			this.data.countPages=this.data.countItems=this.data.items.length;
			//var tmp=this.data.items[0].cloneNode(true);
			//if (tmp.id) tmp.id+='-1';
			//jQuery(list).append(tmp);
			this.data.items=jQuery(list).find('>*');
			//if(this.data.group_count) this.group(id,list,this.data.group_count,this.data.group_tag);
			//this.data.width=jQuery(list).width();//jQuery(container).width();
			jQuery(container).addClass('axs_slider '+this.data.effect+' js');
			this.size_set();
			var prev_next=jQuery(container).find('a.scroll.prev, a.scroll.next');
			if ((this.data.items.length>1)&&(!prev_next.length)){
				jQuery(container/*this.data.items[i]*/).prepend('<a class="scroll prev" data-container="'+id+'" href="#" title="&lt;">'+this.data.prev_lbl+'</a>');
				jQuery(container/*this.data.items[i]*/).prepend('<a class="scroll next" data-container="'+id+'" href="#" title="&gt;">'+this.data.next_lbl+'</a>');
				}
			for (var i=0; i<this.data.items.length; i++){
				//jQuery(this.data.items[i]).css({'display':'block','float':'left'});
				if (!jQuery(this.data.items[i]).attr('id')) jQuery(this.data.items[i]).attr('id',id+'-item'+i);
				/*if ((this.data.items.length>1)&&(!prev_next.length)){
					jQuery(this.data.items[i]).prepend('<a class="scroll next" data-container="'+id+'" href="#" title="&gt;">'+this.data.next_lbl+'</a>');
					jQuery(this.data.items[i]).prepend('<a class="scroll prev" data-container="'+id+'" href="#" title="&lt;">'+this.data.prev_lbl+'</a>');
					}*/
				if (this.data.add_container) this.data.items[i].innerHTML='<'+a.cfg.add_container+'>'+this.data.items[i].innerHTML+'</'+a.cfg.add_container+'>';
				}
			for (var i=0; i<this.data.items.length; i++){
				var prev=(i<=0) ? this.data.items.length-1:i-1;
				jQuery(this.data.items[i]).find('a.scroll.prev').attr('href','#'+jQuery(this.data.items[prev]).attr('id'));
				var next=(i>=this.data.items.length-1) ? 0:i+1;
				jQuery(this.data.items[i]).find('a.scroll.next').attr('href','#'+jQuery(this.data.items[next]).attr('id'));
				}
			//jQuery(container).css({'overflow':'hidden'});
			//jQuery(list).css({/*'whiteSpace':'nowrap',*/'width':(this.data[id].items.length*this.data[id].width)+'px'});
			jQuery(container).find('a.scroll.prev').attr('data-container',id).click(function(){
				var id=this.getAttribute('data-container');
				if (axs.slider.sliders[id].data.playing) axs.slider.sliders[id].animate_btn(id);
				return axs.slider.sliders[id].animate_prev(id);
				});
			jQuery(container).find('a.scroll.next').attr('data-container',id).click(function(){
				var id=this.getAttribute('data-container');
				if (axs.slider.sliders[id].data.playing) axs.slider.sliders[id].animate_btn(id);
				return axs.slider.sliders[id].animate_next(id);
				});
			if (this.data.play){
				if (!jQuery(container).find('a.play').length) jQuery(container).prepend('<a class="play" data-container="'+id+'" href="#'+id+'">'+this.data.play_lbl+'</a>');
				}
			jQuery(container).find('a.play').click(function(){
				var id=this.getAttribute('data-container');
				return axs.slider.sliders[id].animate_btn(id);
				});
			if (this.data.play==='auto') window.setTimeout('axs.slider.sliders["'+id+'"].animate_btn("'+id+'");',this.data.interval+this.data.transition);
			window.addEventListener('load',axs.slider.base.size_set);
			window.addEventListener('resize',axs.slider.base.size_set);
			if(this.data.pager){
				var el=jQuery(container).find('.slider_pager');
				(el.length) ? $(el).replaceWith($('<ul class="slider_pager"></ul>').html($(el).html())):jQuery(container).append('<ul class="slider_pager"></ul>');
				var el=jQuery(container).find('.slider_pager');
				for(var i=1; i<=this.data.countPages; i++){
					var tmp=(this.data.pager==='content')?this.data.items[i-1].innerHTML:i;
					jQuery(el).append('<li class="item'+i+'"><a class="scroll" data-container="'+id+'" data-slide="'+i+'" href="#'+this.data.items[i-1].id+'">'+tmp+'</a></li>');
					}
				jQuery(container).find('.slider_pager a.scroll').click(function(){
					var id=this.getAttribute('data-container');
					axs.slider.sliders[id].data.playing=false;
					axs.slider.sliders[id].animate_scroll(id,parseInt(this.getAttribute('data-slide')));
					return false;
					});
				jQuery(container).find('.slider_pager>*:first-child').addClass('current');
				}
			this.initLocal();
			var css='';
			for (var k in this.cfg.css) css+='	'+k+' '+this.cfg.css[k];
			document.querySelector('html>head').appendChild(axs.elementCreate('style',{},'\n'+css));
			},//</init()>
		initLocal:function(){},//Customize init(). 
		id_get:function(container){//Get ID of the container or generate it if there is none. 
			if (container.id) return container.id;
			var i=1;
			while((!document.getElementById('slider'+i)) && (i<=1000)) i++;
			container.id='slider'+i;
			},//</id_get()>
		size_set:function(){
			for(id in axs.slider.sliders){	axs.slider.sliders[id].size_set();	}
			/*This suits for carousel only!
			var tmp;
			for(id in axs.slider.sliders){
				axs.slider.sliders[id].data.width=jQuery(axs.slider.sliders[id].data.list).parent().width();
				for (var i=0; i<axs.slider.sliders[id].data.items.length; i++) {
					jQuery(axs.slider.sliders[id].data.items[i]).css({'width':axs.slider.sliders[id].data.width+'px'});
					}
				jQuery(axs.slider.sliders[id].data.list).css({'width':(axs.slider.sliders[id].data.items.length*axs.slider.sliders[id].data.width)+'px'});
				if (axs.slider.sliders[id].data.adjust_height)jQuery('#'+id+' .list>*').height(jQuery('#'+id+' .list').height());
				}*/
			},//</size_set()>
		animate_btn:function(id){
			if (axs.slider.sliders[id].data.playing){
				axs.slider.sliders[id].data.playing=false;
				jQuery('#'+id+' a.play').html(axs.slider.sliders[id].data.play_lbl);
				}
			else{
				axs.slider.sliders[id].data.playing=true;
				jQuery('#'+id+' a.play').html(axs.slider.sliders[id].data.pause_lbl);
				axs.slider.sliders[id].animate_play(id);
				}
			return false;
			},//</animate_btn()>
		animate_play:function(id){
			if (!axs.slider.sliders[id].data.playing) return;
			if (axs.window_visible()) this.animate_next(id,'next');
			window.setTimeout('axs.slider.sliders["'+id+'"].animate_play("'+id+'");',axs.slider.sliders[id].data.interval+axs.slider.sliders[id].data.transition);
			},//</animate_play()>
		animate_prev:function(id){
			axs.slider.sliders[id].animate_scroll(id,'prev');
			return false;
			},//</animate_prev()>
		animate_next:function(id){
			axs.slider.sliders[id].animate_scroll(id,'next');
			return false;
			},//</animate_prev()>
		animate_scroll:function(id,action){
			var container=jQuery("#"+id+" .list");
			var w=axs.slider.sliders[id].data.width;
			var left=Math.abs(parseInt(container.css('marginLeft')));
			var current_gone=axs.slider.sliders[id].data.current;
			if (action==='prev') {
				if (left==0) {
					left=w*axs.slider.sliders[id].data.countPages;
					container.css({'marginLeft':-w*(axs.slider.sliders[id].data.items.length-1)+'px'});
					}
				axs.slider.sliders[id].data.current--;
				var pos={'marginLeft':'+='+w+'px'};
				}
			if (action==='next') {
				if (left>=w*axs.slider.sliders[id].data.countPages-1) {
					left=0;
					container.css({'marginLeft':0});
					}
				axs.slider.sliders[id].data.current++;
				var pos={'marginLeft':'-='+w+'px'};
				}
			if (typeof(action)==='number') {
				axs.slider.sliders[id].data.current=action;
				var pos={'marginLeft':'-'+(w*(action-1))+'px'};
				}
			container.animate(pos,"slow");
			if (axs.slider.sliders[id].data.current>axs.slider.sliders[id].data.countPages) axs.slider.sliders[id].data.current=1;
			if (axs.slider.sliders[id].data.current<1) axs.slider.sliders[id].data.current=axs.slider.sliders[id].data.countPages;
			jQuery("#"+id+" .slider_pager>*").removeClass('current');
			jQuery("#"+id+" .slider_pager>*.item"+axs.slider.sliders[id].data.current).addClass('current');
			},//</animate_scroll()>
		group:function(id,container,count,tag){
			var list=jQuery(container).find('>*');
			var nr=0, p=1;
			for(var i=0; i<list.length; i++){
				nr++;
				if(nr===1){
					jQuery(tag).attr('id',id+'-'+p).appendTo(container);
					}
				jQuery(list[i]).detach().appendTo('#'+id+'-'+p);
				if(nr===(count)){
					nr=0;
					p++;
					}
				}
			}//</group()>
		}//</base>
	}//</class::axs.slider>
//2013-01-20}