//2022-08-19
/* Sample HTML structure: 
<form id="axs_ui_accessibility" action="#">
	<script>axs.ui.accessibility.ui('#axs_ui_accessibility',{'l':'en', 'title':'Accessibility','contrast.lbl':'Contrast level'});</script>
</form>
*/
axs.ui.accessibility={
	css:{
		'#axs_ui_accessibility .contrast label':'{	display:inline-block;	border:solid 1px currentColor;	padding:0.25em 1em;	color: var(--txtColorDflt);	background:var(--bgColorDflt);	}',
		'#axs_ui_accessibility .contrast label.v1':'{	color:#ff0;	background:#000;	}',
		'#axs_ui_accessibility .contrast label input':'{	margin:0;	}',
		'#axs_ui_accessibility .contrast label::after':'{	content:"Aaa";	}'
		},
	tr:{'l':'en', 'title':'Accessibility','contrast.lbl':'Contrast level'},
	settings:{contrast:0},
	init:function(){
		var tmp=axs.cookie_get('axs[ui][accessibility]');
		try{	tmp=JSON.parse(tmp);	}	catch{	tmp={};	}
		//if(!tmp) tmp={};
		for(k in this.settings){	this.settings[k]=axs.get(k,tmp,this.settings[k]);	}
		this.contrastSet(this.settings.contrast);
		},//</init()>
	contrastSet:function(val){	document.querySelector('html').setAttribute('data-axs-accessibility-contrast',val);	},
	set:function(val){
		for(k in val){	this.settings[k]=val[k];	}
		axs.cookie_set('axs[ui][accessibility]',JSON.stringify(this.settings));
		},//</set()>
	ui:function(form,tr={}){//<Attach functions to menus />
		if (typeof(form)==='string') form=document.querySelector(form);
		var txt=this.tr;
		for (k in tr){	txt[k]=tr[k];	}
		form.setAttribute('lang',txt.l);
		var title=axs.elementCreate('h2',{},'<a class="toggle-switch" href="#axs_ui_accessibility"><span class="icon" title="'+txt.title+'"></span>'+txt.title+'</a>');
		var content=axs.elementCreate('div',{},
		'	<fieldset class="contrast">\n'+
		'		<legend>'+txt['contrast.lbl']+'</legend>\n'+
		'		<label class="v0" title="'+txt['contrast.lbl']+' 0"><input name="contrast" type="radio" value="0" /> <span>'+txt['contrast.lbl']+'</span> <span>0</span></label>\n'+
		'		<label class="v1" title="'+txt['contrast.lbl']+' 1"><input name="contrast" type="radio" value="1" /> <span>'+txt['contrast.lbl']+'</span> <span>1</span></label>\n'+
		'	</fieldset>\n');
		form.prepend(title,content);
		var el=form.querySelector('input[name="contrast"][value="'+this.settings.contrast+'"]');
		if (el) el.checked=true;
		form.querySelectorAll('input[name="contrast"]').forEach(el=>{
			el.addEventListener('click',function(){
				axs.ui.accessibility.contrastSet(this.value);
				axs.ui.accessibility.set({contrast:this.value});
				});
			});
		}//</ui()>
	}//</class::axs.ui.openClose>
axs.ui.cssAdd(axs.ui.accessibility.css,'axs.ui.accessibility');
axs.ui.accessibility.init();
//2022-07-22