//2022-09-07
/* Static site search engine
Inspired by https://gomakethings.com/how-to-create-a-search-page-for-a-static-website-with-vanilla-js/
If no JS suppoerted, fallback to external search site (replace value="yoursite.com" with your site. 
Sample HTML:
<form id="search-form" class="axs form search" action="https://duckduckgo.com/" method="get">
	<label for="input-search">Enter your search criteria:</label>
	<input type="search" name="q" id="input-search" />
	<input type="hidden" name="sites" value="yoursite.com" />
	<button>Search</button>
</form>
<div id="search-status" role="status">
	<template><p><strong class="matches"></strong> matches found for <mark class="q"></mark></p></template>
</div>
<div id="search-results">
	<template><article><h2 class="title"></h2><a class="link" href=""></a></article></template>
</div>
<script src="axs.js"></script>
<script src="axs.search.static.js"></script>
<script>axs.searchStatic.init('#search-form','#search-status','#"search-results','index.search.js',['a','aa']);</script>
Sample search index:
[
	{
		title: "My awesome article",
		date: "December 18, 2018",
		url: "https://gomakethings.com/my-awesome-article",
		content: "The full text of the content...",
		summary: "A short summary or preview of the content (can also be a clipped version of the first few sentences)..."
	},
	{
		title: "Other article",
		date: "December 18, 2018",
		url: "https://gomakethings.com/other-article",
		content: "The full text of the content...",
		summary: "A short summary or preview of the content (can also be a clipped version of the first few sentences)..."
	},
	// More content...
	];
*/
axs.searchStatic={
	searchIndex:[],
	searchIndexUpdated:0,
	init:function(form,status,list,indexFile,excludeWords=[]){
		// Get the DOM elements
		this.form=document.querySelector(form);
		this.input=document.querySelector(form+' input[type="search"]');
		this.searchStatus=document.querySelector(status);
		var tmp=this.searchStatus.querySelector('template');
		this.searchStatusTpl=tmp.content.cloneNode(true);
		this.resultList=document.querySelector(list);
		var tmp=this.resultList.querySelector('template');
		this.resultListTpl=tmp.content.cloneNode(true);
		this.indexFile=indexFile;
		this.excludeWords=excludeWords;
		// Initialize form
		this.form.addEventListener('submit',function(event){
			event.preventDefault();
			var o=axs.searchStatic;
			if (o.input.value){
				window.history.pushState({},o.input.value,axs.url(window.location.href,{[o.input.name]:o.input.value}));
				}
			o.search();
			});
		var q=axs.url_get(this.input.name);
		if (q){
			this.input.value=q;
			this.search();
			}
		},//</init()>
	search:function(){
		axs.ui.throbber(axs.searchStatic.resultList);
		var time=new Date();
		var time=Math.floor(time.getTime()/1000);
		if (axs.searchStatic.searchIndexUpdated+3600<time) axs.searchStatic.searchIndex=[];
		if (!axs.searchStatic.searchIndex.length) axs.ajax(axs.searchStatic.indexFile,function(status,obj){
			try{	axs.searchStatic.searchIndex=JSON.parse(obj.responseText);	}
			catch{	axs.searchStatic.searchIndex=[];	}
			if (axs.searchStatic.searchIndex.length) axs.searchStatic.searchIndexUpdated=time;
			else console.log('Invalid JSON data @ '+axs.searchStatic.indexFile,obj.responseText);
			axs.searchStatic.searchQuery();
			});
		else axs.searchStatic.searchQuery();
		},//</search()>
	/**
	 * Search for matches
	 * @param  {String} query The term to search for
	 */
	searchQuery:function() {
		var query=this.input.value;
		var excludeWords=this.excludeWords;
		// Create a regex for each query
		let regMap=query.toLowerCase().split(' ').filter(function(word) {
			return word.length && !excludeWords.includes(word);
			}).map(function(word){
				return new RegExp(word, 'i');
				});
		// Get and sort the results
		let results=this.searchIndex.reduce(function(results,article,index){
			// Setup priority count
			let priority = 0;
			// Assign priority
			for (let reg of regMap){
				if (reg.test(article.title)) { priority += 100; }
				let occurences=article.content.match(reg);
				if (occurences) { priority += occurences.length; }
				}
			// If any matches, push to results
			if (priority>0) results.push({
				priority: priority,
				article: article
				});
			return results;
			},[]).sort(function(article1,article2){
				return article2.priority - article1.priority;
				});
		// Display the results
		this.showResults(results);
		},//</search()>
	/**
	 * Show the search results in the UI
	 * @param  {Array}  results The results to display
	 */
	showResults:function(results){
		this.searchStatus.innerHTML=this.resultList.innerHTML='';
		this.searchStatus.appendChild(this.searchStatusTpl.cloneNode(true));
		this.searchStatus.querySelector('.matches').innerHTML=results.length;
		var el=this.searchStatus.querySelector('.q');
		if(el) el.innerHTML=axs.htmlEsc(this.input.value);
		for(var i=0, l=results.length; i<l; i++){
			var r=results[i].article;
			var tmp=this.resultListTpl.cloneNode(true);
			tmp.querySelector('.title').innerHTML=r.title;
			tmp.querySelector('.link').setAttribute('href',r.url);
			tmp.querySelector('.link').innerHTML=r.url;
			this.resultList.appendChild(tmp);
			}
		}//</showResults()>
	}//</class::axs.searchStatic>
//2022-07-29